#version 330

uniform sampler1D transformMap;
uniform mat4 view;
uniform mat4 proj;

in vec4 vertex;
in vec4 colour;
in vec3 uv0; //other vertex
in vec3 uv1; //tr idx, other tr idx, right/left
in vec2 uv2; //texCoords

out vec4 vcolor;
out vec2 uv;

void main()
{
	mat3x4 worldT;
	int fetchBase;
	fetchBase = int(3*uv1.x + 0.5);
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	vec4 worldPos0 = vec4(vertex * worldT, 1.0);
	
	fetchBase = int(3*uv1.y + 0.5);
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	vec4 worldPos1 = vec4(vec4(uv0, 1.0) * worldT, 1.0);
	
	vec4 viewPos0 = view * worldPos0;
	vec4 viewPos1 = view * worldPos1;
	
	vec2 perpVs = vec2(viewPos1.y - viewPos0.y, viewPos0.x - viewPos1.x);
	vcolor = colour;
	uv = vec2(uv2.x*length(perpVs)*4, uv2.y);
	gl_Position = proj * ((uv1.z*0.0125) * vec4(normalize(perpVs), 0, 0) + viewPos0);
}
